local t = Def.ActorFrame{};

-- parastar-like star-based grade display
--[[
0-999 = 0 stars
1,000 - 2,999 = 1 star
3,000 - 4,999 = 2 stars
5,000 - 6,999 = 3 stars
7,000 - 8,999 = 4 stars
9,000 - 10,000 = 5 stars

"SO! If i were halfway through a song with 5,000 points -- that would mean as a
percentage (figuring in the rest of the song at the same success rate) I'd have
5 stars."

friends:
--pss[pn]:GetPossibleDancePoints() and Actual
--]]
local numStars = 5;
local starWidth = 32;

local ss = STATSMAN:GetCurStageStats();
local pss = {};
for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	local stars = Def.ActorFrame{
		InitCommand=function(self)
			self:x(pn == PLAYER_1 and SCREEN_CENTER_X-309 or SCREEN_CENTER_X+118);
			self:y(SCREEN_TOP+26);
		end;
	};
	pss[pn] = ss:GetPlayerStageStats(pn);
	for i=1,numStars do
		--currently operating under the assumption that stars are binary
		stars[#stars+1] = Def.ActorFrame{
			Def.Sprite{
				Name="Fill"..i;
				InitCommand=cmd(x,starWidth*i-1);
				BeginCommand=function(self)
					self:Load( THEME:GetPathG("ScreenGameplay","stars/full") );
				end;
				OnCommand=cmd(playcommand,"Update");
				JudgmentMessageCommand=cmd(playcommand,"Update");
				UpdateCommand=function(self)
					local actualDP = pss[pn]:GetActualDancePoints();
					local totalDP = pss[pn]:GetPossibleDancePoints();
					local now = 0;
					local song = GAMESTATE:GetCurrentSong();
					if song then
						now = GAMESTATE:GetSongPercent(GAMESTATE:GetSongBeat()-song:GetFirstBeat());
					end;
					local percentDP = actualDP/(totalDP*now);
						self:visible(i * 0.2 <= percentDP);
				end;
			};
			LoadActor(THEME:GetPathG("ScreenGameplay","stars/empty"))..{
				Name="Frame"..i;
				InitCommand=cmd(x,starWidth*i-1);
			};
		};
	end;
	t[#t+1] = stars;
end;

return t;